/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.tables.VWAttributeNameCellEditor;
import filenet.vw.toolkit.design.property.tables.VWAttributesTableModel;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWStepAttributesTab
extends JPanel
implements IVWPropertyTab,
IVWTableActionListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
TableModelListener {
    private VWToolbarBorder m_toolbarBorder = null;
    private VWAttributesTableModel m_attributesTableModel = null;
    private VWTable m_attributesTable = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMapNode m_mapNode = null;
    private boolean m_bFirstTime = true;

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            this.m_attributesTable.fitColumnsInTable();
        }
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.setSelectedStep(vwMapNode);
            this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        try {
            this.m_attributesTable.editingCanceled(new ChangeEvent(this));
            this.m_mapNode = vwMapNode;
            this.m_attributesTableModel.setSelectedStep(vwMapNode);
            if (this.m_attributesTableModel.getRowCount() > 0) {
                this.m_attributesTable.setRowSelectionInterval(0, 0);
            } else {
                JPanel source = this.m_toolbarBorder.getClientPanel();
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 0x10000000));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_toolbarBorder != null) {
            this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
            this.m_toolbarBorder.releaseReferences();
            this.m_toolbarBorder = null;
        }
        if (this.m_attributesTableModel != null) {
            this.m_attributesTableModel.releaseReferences();
            this.m_attributesTableModel = null;
        }
        if (this.m_attributesTable != null) {
            this.m_attributesTable.getSelectionModel().removeListSelectionListener(this);
            this.m_attributesTable.removeAll();
            this.m_attributesTable = null;
        }
        this.m_authPropertyData = null;
        this.m_mapNode = null;
        this.removeAll();
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                this.m_attributesTable.stopEditing();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        JPanel source = this.m_toolbarBorder.getClientPanel();
        this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 0x10000000));
        int nRowindex = this.m_attributesTable.getSelectedRow();
        if (this.m_attributesTableModel != null && nRowindex != -1 && nRowindex != this.m_attributesTableModel.getRowCount() - 1) {
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 0x10000000));
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (this.m_attributesTable == null || this.m_attributesTableModel == null) {
            return;
        }
        switch (event.getID()) {
            case 0x10000000: {
                this.m_attributesTableModel.deleteItem(this.m_attributesTable.getSelectedRow());
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        try {
            switch (event.getType()) {
                case -1: 
                case 1: {
                    int nRowIndex = event.getLastRow() - 1;
                    if (nRowIndex < 0) {
                        nRowIndex = 0;
                    }
                    if (nRowIndex == this.m_attributesTable.getSelectedRow()) {
                        this.m_attributesTable.clearSelection();
                    }
                    this.m_attributesTable.setRowSelectionInterval(nRowIndex, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.m_toolbarBorder = new VWToolbarBorder(VWResource.s_attributes, 0x10000000);
            this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolbarBorder, gbCons);
            JPanel clientPanel = this.m_toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_attributesTableModel = new VWAttributesTableModel(this.m_authPropertyData, this.m_mapNode);
            this.m_attributesTableModel.addTableModelListener(this);
            this.m_attributesTable = new VWTable(this.m_attributesTableModel);
            this.m_attributesTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_attributesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_attributesTable.setName("m_attributesTable_VWAttributesPanel");
            this.m_attributesTable.getSelectionModel().addListSelectionListener(this);
            this.m_attributesTable.getSelectionModel().setSelectionMode(0);
            TableColumn tcElement = this.m_attributesTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setCellEditor(new VWAttributeNameCellEditor(this.m_authPropertyData));
            }
            if ((tcElement = this.m_attributesTable.getColumnModel().getColumn(1)) != null) {
                tcElement.setCellEditor(new DefaultCellEditor(this.m_attributesTableModel.getFieldTypeComboBox()));
                tcElement.setCellRenderer(new VWFieldsCellRenderer());
            }
            if ((tcElement = this.m_attributesTable.getColumnModel().getColumn(2)) != null) {
                tcElement.setCellEditor(new VWFieldsCellEditor(this.m_authPropertyData.getMainContainer(), false));
                tcElement.setCellRenderer(new VWFieldsCellRenderer());
            }
            clientPanel.add((Component)new JScrollPane(this.m_attributesTable), "Center");
            ++gbCons.gridx;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

